<?php
defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    'rescue_url',
    'rescue_key',
    'total_uses',
    'created_at'
];

$sIndexColumn = 'id';
$sTable = db_prefix() . 'rescuesystem_keys';

$join = [];
$where = [];

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
    'id'
]);

$output = $result['output'];
$rResult = $result['rResult'];


foreach ($rResult as $aRow) {
    $row = [];
    for ($i = 0; $i < count($aColumns); $i++) {

        $row[] = "<a href='" . $aRow['rescue_url'] . "' target='_blank'>" . $aRow['rescue_url'] . "</a>";
        $row[] = $aRow['rescue_key'];
        $row[] = $aRow['total_uses'];
        $row[] = $aRow['created_at'];

        $options = '<div class="tw-flex tw-items-center tw-space-x-3">';
        $options .= '<a href="' . admin_url('rescuesystem/download/' . $aRow['id']) . '" class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700">
        <i class="fas fa-download fa-lg"></i>
    </a>';

        $options .= '<a href="' . admin_url('rescuesystem/delete/' . $aRow['id']) . '"
    class="tw-mt-px tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700 _delete">
        <i class="fa-regular fa-trash-can fa-lg"></i>
    </a>';

        $options .= '</div>';

        $row[] = $options;
    }

    $output['aaData'][] = $row;
}
