<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Rescue Mode for Perfex CRM
Description: Ensure the stability and security of your Perfex CRM with Rescue Mode. This powerful module allows you to disable or activate problematic modules swiftly during technical issues, preventing disruptions and enabling faster troubleshooting. With an intuitive interface, real-time module management, and a secure key-based access system, Rescue Mode keeps your CRM running smoothly, helping you maintain productivity even in critical situations.
Version: 1.0.0
Author: Lenzcreative
Author URI: https://lenzcreative.net/perfex-crm-modules/
Requires at least: 1.0.*
*/

define('RESCUESYSTEM_MODULE_NAME', 'rescuesystem');

hooks()->add_action('admin_init', 'rescuesystem_module_init_menu_items');
hooks()->add_action('rescuesystem_init', RESCUESYSTEM_MODULE_NAME . '_appint');
hooks()->add_action('pre_activate_module', RESCUESYSTEM_MODULE_NAME . '_preactivate');
hooks()->add_action('pre_deactivate_module', RESCUESYSTEM_MODULE_NAME . '_predeactivate');
hooks()->add_action('pre_uninstall_module', RESCUESYSTEM_MODULE_NAME . '_uninstall');

/**
 * Load the module helper
 */
$CI = &get_instance();
$CI->load->helper(RESCUESYSTEM_MODULE_NAME . '/rescuesystem');

/**
 * Register activation module hook
 */
register_activation_hook(RESCUESYSTEM_MODULE_NAME, 'rescuesystem_module_activation_hook');

function rescuesystem_module_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(RESCUESYSTEM_MODULE_NAME, [RESCUESYSTEM_MODULE_NAME]);

/**
 * Init module menu items in setup in admin_init hook
 * @return null
 */
function rescuesystem_module_init_menu_items()
{
    $CI = &get_instance();

    if (is_admin()) {
        $CI->app_menu->add_setup_menu_item('rescuesystem', [
            'slug' => 'rescuesystem',
            'name' => _l('rescuesystem'),
            'position' => 0,
            'href' => admin_url('rescuesystem/manage'),
            'icon' => 'fa fa-lock'
        ]);
    }
}

function rescuesystem_appint()
{
    
}

function rescuesystem_preactivate($module_name)
{
    if ($module_name['system_name'] == RESCUESYSTEM_MODULE_NAME) {

    }
}

function rescuesystem_predeactivate($module_name)
{
    if ($module_name['system_name'] == RESCUESYSTEM_MODULE_NAME) {

    }
}

function rescuesystem_uninstall($module_name)
{
    if ($module_name['system_name'] == RESCUESYSTEM_MODULE_NAME) {

    }
}
