<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Rescuesystem_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function create($data)
    {
        $this->db->insert(db_prefix() . 'rescuesystem_keys', $data);
        $insert_id = $this->db->insert_id();

        if ($insert_id) {
            return $insert_id;
        }

        return false;
    }

    public function get($id)
    {
        $this->db->where('id', $id);
        return $this->db->get(db_prefix() . 'rescuesystem_keys')->row();
    }

    public function get_all()
    {
        return $this->db->get(db_prefix() . 'rescuesystem_keys')->result_array();
    }

    public function update($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'rescuesystem_keys', $data);

        return $this->db->affected_rows() > 0;
    }

    public function delete($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'rescuesystem_keys');

        return $this->db->affected_rows() > 0;
    }

}
