<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class EntityOptions {
    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return CreateEntityOptions Options builder
     */
    public static function create(string $twilioSandboxMode = Values::NONE): CreateEntityOptions {
        return new CreateEntityOptions($twilioSandboxMode);
    }

    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return DeleteEntityOptions Options builder
     */
    public static function delete(string $twilioSandboxMode = Values::NONE): DeleteEntityOptions {
        return new DeleteEntityOptions($twilioSandboxMode);
    }

    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return FetchEntityOptions Options builder
     */
    public static function fetch(string $twilioSandboxMode = Values::NONE): FetchEntityOptions {
        return new FetchEntityOptions($twilioSandboxMode);
    }

    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return ReadEntityOptions Options builder
     */
    public static function read(string $twilioSandboxMode = Values::NONE): ReadEntityOptions {
        return new ReadEntityOptions($twilioSandboxMode);
    }
}

class CreateEntityOptions extends Options {
    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     */
    public function __construct(string $twilioSandboxMode = Values::NONE) {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
    }

    /**
     * The Twilio-Sandbox-Mode HTTP request header
     *
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return $this Fluent Builder
     */
    public function setTwilioSandboxMode(string $twilioSandboxMode): self {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.CreateEntityOptions ' . $options . ']';
    }
}

class DeleteEntityOptions extends Options {
    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     */
    public function __construct(string $twilioSandboxMode = Values::NONE) {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
    }

    /**
     * The Twilio-Sandbox-Mode HTTP request header
     *
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return $this Fluent Builder
     */
    public function setTwilioSandboxMode(string $twilioSandboxMode): self {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.DeleteEntityOptions ' . $options . ']';
    }
}

class FetchEntityOptions extends Options {
    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     */
    public function __construct(string $twilioSandboxMode = Values::NONE) {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
    }

    /**
     * The Twilio-Sandbox-Mode HTTP request header
     *
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return $this Fluent Builder
     */
    public function setTwilioSandboxMode(string $twilioSandboxMode): self {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.FetchEntityOptions ' . $options . ']';
    }
}

class ReadEntityOptions extends Options {
    /**
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     */
    public function __construct(string $twilioSandboxMode = Values::NONE) {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
    }

    /**
     * The Twilio-Sandbox-Mode HTTP request header
     *
     * @param string $twilioSandboxMode The Twilio-Sandbox-Mode HTTP request header
     * @return $this Fluent Builder
     */
    public function setTwilioSandboxMode(string $twilioSandboxMode): self {
        $this->options['twilioSandboxMode'] = $twilioSandboxMode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Verify.V2.ReadEntityOptions ' . $options . ']';
    }
}