<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Approvify
Description: Online Approvals Management for Perfex CRM. Streamline and accelerate your approval processes with ease. Automate workflows, gain real-time insights, and ensure compliance effortlessly. Optimize efficiency, reduce bottlenecks, and improve decision-making. Elevate your CRM experience with seamless approvals.
Version: 1.2.0
Author: LenzCreative
Author URI: https://codecanyon.net/user/lenzcreativee/portfolio
Requires at least: 1.0.*
*/

define('APPROVIFY_MODULE_NAME', 'approvify');

hooks()->add_action('admin_init', 'approvify_module_init_menu_items');
hooks()->add_action('admin_init', 'approvify_permissions');
hooks()->add_action('approvify_init', APPROVIFY_MODULE_NAME . '_appint');
hooks()->add_action('pre_activate_module', APPROVIFY_MODULE_NAME . '_preactivate');
hooks()->add_action('pre_deactivate_module', APPROVIFY_MODULE_NAME . '_predeactivate');
hooks()->add_action('pre_uninstall_module', APPROVIFY_MODULE_NAME . '_uninstall');


require(__DIR__ . '/services/ApprovifyRequestsKanBan.php');

/**
 * Load the module helper
 */
$CI = &get_instance();
$CI->load->helper(APPROVIFY_MODULE_NAME . '/approvify'); //on module main file

function approvify_permissions()
{
    $capabilities = [];

    $capabilities['capabilities'] = [
        'view' => _l('permission_view'),
        'create' => _l('permission_create'),
        'edit' => _l('permission_edit'),
        'delete' => _l('permission_delete'),
        'create_category' => _l('approvify_create_categories'),
    ];
    register_staff_capabilities('approvify', $capabilities, _l('approvify'));
}

/**
 * Register activation module hook
 */
register_activation_hook(APPROVIFY_MODULE_NAME, 'approvify_module_activation_hook');

function approvify_module_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(APPROVIFY_MODULE_NAME, [APPROVIFY_MODULE_NAME]);

/**
 * Init module menu items in setup in admin_init hook
 * @return null
 */
function approvify_module_init_menu_items()
{
    $CI = &get_instance();

    if (has_permission('approvify', '', 'view')) {
        $CI->app_menu->add_sidebar_menu_item('approvify', [
            'slug' => 'approvify',
            'name' => _l('approvify_mod_name'),
            'position' => 6,
            'icon' => 'fas fa-check'
        ]);
    }

    if (has_permission('approvify', '', 'create')) {
        $CI->app_menu->add_sidebar_children_item('approvify', [
            'slug' => 'approvify-create-request',
            'name' => _l('approvify_request'),
            'position' => 6,
            'icon' => 'fas fa-plus-circle',
            'href' => admin_url('approvify/manage_requests')
        ]);
    }

    if (has_permission('approvify', '', 'create')) {
        $CI->app_menu->add_sidebar_children_item('approvify', [
            'slug' => 'approvify-my-request',
            'name' => _l('approvify_my_requests'),
            'position' => 6,
            'icon' => 'fas fa-tasks',
            'href' => admin_url('approvify/manage_created_requests')
        ]);
    }

    if (has_permission('approvify', '', 'view')) {
        $CI->app_menu->add_sidebar_children_item('approvify', [
            'slug' => 'approvify-review-request',
            'name' => _l('approvify_review_requests'),
            'position' => 6,
            'icon' => 'fas fa-exchange-alt',
            'href' => admin_url('approvify/manage_review_requests')
        ]);
    }

    if (has_permission('approvify', '', 'create_category')) {
        $CI->app_menu->add_sidebar_children_item('approvify', [
            'slug' => 'approvify-request-categories',
            'name' => _l('approvify_categories'),
            'position' => 6,
            'icon' => 'fas fa-layer-group',
            'href' => admin_url('approvify/manage_types')
        ]);
    }
}

hooks()->add_action('after_custom_fields_select_options', 'approvify_new_custom_field_types');
function approvify_new_custom_field_types($custom_field)
{
    require(__DIR__ . '/models/Approvify_model.php');

    $CI = &get_instance();
    $CI->load->model('approvify_model');

    $approvifyCategories = $CI->approvify_model->getTypes();

    if (!empty($approvifyCategories)) {
        foreach ($approvifyCategories as $category) {
            ?>
            <option value="approvify_<?php echo $category['id']; ?>" <?php if (isset($custom_field) && $custom_field->fieldto == 'approvify_' . $category['id']) {
                echo 'selected';
            } ?>>Staff Approvals Category | <?php echo $category['category_name'] ?: ''; ?></option>
            <?php
        }
    }
}

function approvify_appint()
{
    
}

function approvify_preactivate($module_name)
{
    if ($module_name['system_name'] == APPROVIFY_MODULE_NAME) {

    }
}

function approvify_predeactivate($module_name)
{
    if ($module_name['system_name'] == APPROVIFY_MODULE_NAME) {

    }
}

function approvify_uninstall($module_name)
{
    if ($module_name['system_name'] == APPROVIFY_MODULE_NAME) {

    }
}
