<?php init_head(); ?>
<div id="wrapper">
   <div class="content">
      <div class="row">
         <div class="col-md-12" id="small-table">
            <div class="panel_s">
               <div class="panel-body">
                  <h4 class="tw-mt-0 tw-font-semibold tw-text-lg tw-flex tw-items-center">
                     <span><?php echo _l('locked_list') ?></span>
                  </h4>
                  <hr class="hr-panel-separator">
                  <?php if (count($users) > 0) { ?>
                  <table class="table dt-table" data-order-col="0" data-order-type="asc">
                     <thead>
                        <th><?php echo _l('ip'); ?></th>
                        <th><?php echo _l('useragent'); ?></th>
                        <th><?php echo _l('locked_until'); ?></th>
                        <th><?php echo _l('last_attempt_at'); ?></th>
                        <th></th>
                     </thead>
                     <tbody>
                        <?php foreach ($users as $user) { ?>
                        <tr>
                          
                           <td><?php echo $user['ip']; ?></td>
                           <td><?php echo  get_browser_info($user['useragent']); ?></td>
                           <td>
                              <?php if ($user['locked_until'] != null) { ?>
                              <span class="text-has-action is-date" data-toggle="tooltip" data-title="<?php echo $user['locked_until'] ?> . '"><?php echo  display_calculate_remaining_time($user['locked_until']); ?></span>
                              <?php } else { 
                                 echo _l('never');
                                 }?>
                           <td><?php echo time_ago($user['last_attempt_at']); ?></td>
                           <td>
                            <?php if($user['attempt_count'] >= get_option('allow_retries')){ ?>
                              <a data-id="<?php echo $user['loginattemptstid']; ?>" class="btn btn-sm btn-default pull-left mleft5 unlock"> <?php echo _l('unlock') ?></a>
                            <?php }else{ echo 'Not Locked'; } ?>
                           </td>
                        </tr>
                        <?php } ?>
                     </tbody>
                  </table>
                  <?php } else { ?>
                  <p class="no-margin text-center"><?php echo _l('data_not_found'); ?></p>
                  <?php } ?>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<?php init_tail(); ?>
<script>
   $("body").on('click', '.unlock', function () {
      var data = {};
      data.id = $(this).attr('data-id');
      $.post(admin_url + 'login_attempt_guard/unlock_staff', data).done(function(response){
         alert_float('success', '<?php echo _l('unlock_msg') ?>');
         setTimeout(() => {
            location.reload();
         }, 2);
      });
   });
</script>
</body>
</html>