<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Login_attempts_guard_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();

    }
    /**
     * Retrieves login attempts for a specific member or all members.
     *
     * @param string $id The ID of the  member (optional).
     * @return mixed If an ID is provided, returns a single record; otherwise, returns an array of all records.
     */
    public function get($id = ''){
        if($id == ''){
            return  $this->db->get(db_prefix().'login_attempts_guard')->result_array();
        }else{
            $this->db->where('id',$id);
            return $this->db->get(db_prefix().'login_attempts_guard')->row();
        }
    }

    /**
     * Retrieves all locked  members who have reached the maximum allowed login attempts.
     *
     * @return array An array of locked  members with their details.
     */
    public function all(){

        $CI = &get_instance();
        $CI->db->select('login_attempts_guard.email_id,login_attempts_guard.attempt_count, login_attempts_guard.ip, 
                        login_attempts_guard.useragent, login_attempts_guard.locked_until,login_attempts_guard.last_attempt_at,login_attempts_guard.loginattemptstid');
        $CI->db->from(db_prefix() . 'login_attempts_guard');
        $CI->db->where('login_attempts_guard.locked_until IS NULL');
        $CI->db->or_where('login_attempts_guard.locked_until >=', date('Y-m-d H:i:s')); 
        $query = $CI->db->get();

        return $query->result_array();

    }
    /**
     * Deletes the login attempts record for a specific  member, effectively unlocking the account.
     *
     * @param int $id The ID of the  member to unlock.
     * @return int Returns 1 after successful deletion.
     */
    public function delete($id)
    {
        $this->db->where('loginattemptstid', $id);
        $this->db->delete(db_prefix() . 'login_attempts_guard');
        return 1;
    }
}